$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Tabela para Cadastro',
          description: 'Abas referentes às telas, com campos a serem preenchidos com valores padrões.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para gravar os Valores Padrões.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const parametrosVenda = await BuscaParametrosVenda();
  if (!['1', '3', '4'].includes(parametrosVenda[72])) {
    $('#tabCashback').addClass('d-none');
  }
  let regrasPedido = [
    // PEDIDO INCLUSÃO
    {
      TIPO: "INCLUSAO", CODIGO: "1", REGRA: "1", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear item com valor abaixo da Tabela de Preço.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: false },
      INPUT: [{ TYPE: "text", PLACEHOLDER: "Percentual Mínimo", PROPERTY: "DESCRICAO" }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "2", REGRA: "2", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear item com comissão maior que da Tabela.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: false },
      INPUT: [{ TYPE: "text", PLACEHOLDER: "Percentual Máximo", PROPERTY: "DESCRICAO" }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "3", REGRA: "3", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando Desconto for Maior que Percentual Máximo.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: false },
      INPUT: [{ TYPE: "text", PLACEHOLDER: "Percentual Máximo", PROPERTY: "DESCRICAO" }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "4", REGRA: "4", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando Prazo for maior que o Prazo Máximo Permitido.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: false },
      INPUT: [{ TYPE: "text", PLACEHOLDER: "Máximo de Dias", PROPERTY: "DESCRICAO" }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "5", REGRA: "5", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando o preço na tabela de preços for zero.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "INCLUSAO", CODIGO: "6", REGRA: "6", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando grupo do produto estiver igual aos grupos selecionados',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: false },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Grupo", PROPERTY: "DESCRICAO2",
        COMPONENTEFILTRO: {
          TABELA: 'GRUPO_PA', COMP_TABELA: "grupoPA", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "7", REGRA: "7", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando existe valor de Bonificação.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "INCLUSAO", CODIGO: "8", REGRA: "8", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando parcela mínima for menor que o estipulado.',
      BLOQUEIOS: { COMERCIAL: false, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "9", REGRA: "9", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando Limite de Crédito do Cliente for Ultrapassado.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{ TYPE: "text", PLACEHOLDER: "Prazo Superior", PROPERTY: "DESCRICAO" }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "10", REGRA: "10", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando Cliente possuir Duplicatas em Atraso.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "INCLUSAO", CODIGO: "11", REGRA: "11", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando a data da última compra for maior que X dias.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{ TYPE: "text", PLACEHOLDER: "Dias", PROPERTY: "DESCRICAO" }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "12", REGRA: "12", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na Inclusão quando a situação da duplicata estiver selecionadas',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Situações", PROPERTY: "DESCRICAO2",
        COMPONENTEFILTRO: {
          TABELA: 'TABSIT', COMP_TABELA: "situacao", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "13", REGRA: "13", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando o score Serasa for menor que o estipulado',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{ TYPE: "text", PLACEHOLDER: "Score", PROPERTY: "DESCRICAO" }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "14", REGRA: "14", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando fundação cliente é menor que X dias e usou as moedas',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [
        {
          TYPE: "text", PLACEHOLDER: "Dias", PROPERTY: "DESCRICAO"
        },
        {
          TYPE: "select", PLACEHOLDER: "Moedas", PROPERTY: "DESCRICAO2",
          COMPONENTEFILTRO: {
            TABELA: 'MOEDA', COMP_TABELA: "moeda", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
            WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
          }
        }
      ]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "15", REGRA: "15", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão se média dias atraso pagamento for maior que o estipulado',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "text", PLACEHOLDER: "Média Atraso", PROPERTY: "DESCRICAO"
      }],
    },
    {
      TIPO: "INCLUSAO", CODIGO: "16", REGRA: "16", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando Valor CIF for 0 e Valor Frete for 0.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "17", REGRA: "17", TABELA: 'PEDIDO',
      DESCRICAO: 'Cliente sem consulta no sintegra ou vencida',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "18", REGRA: "18", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear por ter empresa coligada',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "19", REGRA: "19", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear cliente inativo',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "20", REGRA: "20", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear cliente com suframa menor que data pedido',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "21", REGRA: "21", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear cliente cujo UF é EX (EXTERIOR)',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "22", REGRA: "22", TABELA: 'PEDIDO',
      DESCRICAO: 'Data limite de crédito vencido',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "23", REGRA: "23", TABELA: 'PEDIDO',
      DESCRICAO: 'Limite de crédito está suspenso',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "24", REGRA: "24", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando cliente tiver cadastro de informações gerais pendente.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "25", REGRA: "25", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando algum cliente do mesmo grupo possuir duplicatas em atraso',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "26", REGRA: "26", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando rentabilidade for negativa',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "27", REGRA: "27", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na inclusão quando a Condição do Pedido for 0 - à vista',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "28", REGRA: "28", TABELA: 'PEDIDO',
      DESCRICAO: 'Cliente sem Data Atualização ou vencida',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "29", REGRA: "29", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando item / cor estiver inativo na Coleção',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "30", REGRA: "30", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando item / cor estiver fora de Coleção',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "31", REGRA: "31", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando possuir o histórico igual aos selecionados',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Histórico", PROPERTY: "DESCRICAO2",
        COMPONENTEFILTRO: {
          TABELA: 'HISTCP', COMP_TABELA: "historico", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "32", REGRA: "32", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando tipo de venda for igual aos selecionados',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Tipo Venda", PROPERTY: "DESCRICAO",
        COMPONENTEFILTRO: {
          TABELA: 'TIPO', COMP_TABELA: "tipoPedido", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "33", REGRA: "33", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloqueia quando item possui categoria informada',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "Categoria", PROPERTY: "DESCRICAO",
        COMPONENTEFILTRO: {
          TABELA: 'AUXILIAR', COMP_TABELA: "auxiliar", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "34", REGRA: "34", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando cliente possuir duplicatas em atraso superior à XXX dias.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [
        {
          TYPE: "text", PLACEHOLDER: "Dias", PROPERTY: "DESCRICAO"
        }
      ]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "35", REGRA: "35", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando cliente de UF que não permite IE vazia ou isenta',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "select", PLACEHOLDER: "UF", PROPERTY: "DESCRICAO",
        COMPONENTEFILTRO: {
          TABELA: 'TABUF', COMP_TABELA: "tabuf", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "INCLUSAO", CODIGO: "36", REGRA: "36", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando cliente tiver históricos com bloqueio de pedido',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "37", REGRA: "37", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando cond. pagamento bloqueia pedido e não tiver valor do pedido antecipado',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
    },
    {
      TIPO: "INCLUSAO", CODIGO: "38", REGRA: "38", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando cliente sem atualização do Sintegra maior que XXX dias',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [
        {
          TYPE: "text", PLACEHOLDER: "Dias", PROPERTY: "DESCRICAO"
        }
      ]
    },

    // PEDIDO ALTERAÇÃO
    {
      TIPO: "ALTERACAO", CODIGO: "1", REGRA: "1", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração do Código do Cliente.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "2", REGRA: "2", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração do Código do Representante',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "3", REGRA: "3", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração das Comissões',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "4", REGRA: "4", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração do Transportador, Transporte ou Pagto de Frete',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "5", REGRA: "5", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração da Tabela de Preço',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "6", REGRA: "6", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração do Campo Prazo de Entrega',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "7", REGRA: "7", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração das Condições de Pagamento',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "8", REGRA: "8", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração das Datas de Entrega e Fatura',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "9", REGRA: "9", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração dos Descontos',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "10", REGRA: "10", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração dos Itens do Pedido',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "11", REGRA: "11", TABELA: 'PEDIDO',
      DESCRICAO: 'Percentual Aceitável de Cancelamento',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "text", PLACEHOLDER: "Percentual", PROPERTY: "DESCRICAO"
      }],
    },
    {
      TIPO: "ALTERACAO", CODIGO: "12", REGRA: "12", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear ao Faturar pedido Parcialmente',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "13", REGRA: "13", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear ao Faturar pedido Parcialmente',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "14", REGRA: "14", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração quando o preço na tabela de preços for zero',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "15", REGRA: "15", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração quando o status:',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "16", REGRA: "16", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquar na alteração quando existe valor de Bonificação.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "17", REGRA: "17", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando parcela mínima for menor que o estipulado',
      BLOQUEIOS: { COMERCIAL: false, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "18", REGRA: "18", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando Limite de Crédito do Cliente for Ultrapassado.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "19", REGRA: "19", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando Cliente possuir Duplicatas em Atraso.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "20", REGRA: "20", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração quando a situação da duplicata estiver selecionadas.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Situações", PROPERTY: "DESCRICAO2",
        COMPONENTEFILTRO: {
          TABELA: 'TABSIT', COMP_TABELA: "situacao", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "21", REGRA: "21", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando Prazo for maior que o Prazo Máximo Permitido',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: false },
      INPUT: [{
        TYPE: "text", PLACEHOLDER: "Máx Dias", PROPERTY: "DESCRICAO"
      }],
    },
    {
      TIPO: "ALTERACAO", CODIGO: "22", REGRA: "22", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração quando a data da última compra for maior que X dias.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "text", PLACEHOLDER: "Dias", PROPERTY: "DESCRICAO"
      }],
    },
    {
      TIPO: "ALTERACAO", CODIGO: "23", REGRA: "23", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na alteração quando Valor CIF for 0 e Valor Frete for 0.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "24", REGRA: "24", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear, quando valor do pedido ficar superior ao que estava salvo antes',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "25", REGRA: "25", TABELA: 'PEDIDO',
      DESCRICAO: 'Condição de pagamento alterada.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "26", REGRA: "26", TABELA: 'PEDIDO',
      DESCRICAO: 'Data limite de crédito vencido.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "27", REGRA: "27", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear cliente inativo.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "28", REGRA: "28", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear cliente com suframa menor que data pedido.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "29", REGRA: "29", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear cliente cujo UF é EX (EXTERIOR)',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "30", REGRA: "30", TABELA: 'PEDIDO',
      DESCRICAO: 'Limite de crédito está suspenso.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "31", REGRA: "31", TABELA: 'PEDIDO',
      DESCRICAO: 'Cliente sem consulta no sintegra ou vencida.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "32", REGRA: "32", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear por ter empresa coligada.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "33", REGRA: "33", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando cliente tiver cadastro de informações gerais pendente.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "34", REGRA: "34", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando algum cliente do mesmo grupo possuir duplicatas em atraso.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "35", REGRA: "35", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na Alteração quando rentabilidade for negativa',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "36", REGRA: "36", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear na Alteração quando a Condição do Pedido for 0 - à vista',
      BLOQUEIOS: { COMERCIAL: false, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Status", PROPERTY: "STATUS",
        COMPONENTEFILTRO: {
          TABELA: 'SITPROD', COMP_TABELA: "status", RETORNAMAISDEUMREGISTRO: false, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
    {
      TIPO: "ALTERACAO", CODIGO: "37", REGRA: "37", TABELA: 'PEDIDO',
      DESCRICAO: 'Cliente sem Data Atualização ou vencida.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "38", REGRA: "38", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando item / cor estiver inativo na Coleção.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "39", REGRA: "39", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando item / cor estiver fora de Coleção.',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true }
    },
    {
      TIPO: "ALTERACAO", CODIGO: "40", REGRA: "40", TABELA: 'PEDIDO',
      DESCRICAO: 'Bloquear quando possuir o histórico igual aos selecionados:',
      BLOQUEIOS: { COMERCIAL: true, FINANCEIRO: true },
      INPUT: [{
        TYPE: "SELECT", PLACEHOLDER: "Situações", PROPERTY: "DESCRICAO2",
        COMPONENTEFILTRO: {
          TABELA: 'TABSIT', COMP_TABELA: "situacao", RETORNAMAISDEUMREGISTRO: true, SERVERSIDE: true,
          WHERE: [], IGNORARPESQUISASPADROES: false, CALLBACK: null
        }
      }]
    },
  ];

  criaDataTablePadrao('#tabelaRegraPedidoINCLUSAO', false, false, false, false, true, false);
  criaDataTablePadrao('#tabelaRegraPedidoALTERACAO', false, false, false, false, true, false);

  preencheCampos();

  $('#tabelaRegraPedidoALTERACAO').DataTable().columns.adjust().draw(false);
  $('#tabelaRegraPedidoINCLUSAO').DataTable().columns.adjust().draw(false);

  $("#tabInclusaoPedido, #tabAlteracaoPedido").on('click', function () {
    setTimeout(() => {
      $('#tabelaRegraPedidoALTERACAO').DataTable().columns.adjust().draw(false);
      $('#tabelaRegraPedidoINCLUSAO').DataTable().columns.adjust().draw(false);
    }, 175);

    $("#btnGravar").removeClass("d-none");
  });

  function existePesquisa(campos) {
    const retorno = campos.INPUT?.find(item => {
      return item.COMPONENTEFILTRO ? true : false
    })
    return retorno
    // return campos.INPUT?.COMPONENTEFILTRO ? true : false;
  };

  $('#btnGravar').on('click', async function () {
    await Gravar()
  })

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
      orderBy: ['EMP_PAT']
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#txtCRIAR_PEDIDOEMP_FAT").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', '')));
    });
  };

  function retornaLinhaTabela(item, idx) {
    if (!item.BLOQUEIOS.COMERCIAL && !item.BLOQUEIOS.FINANCEIRO) {
      console.error(`[Regra: ${idx}] Necessário informar um tipo de bloqueio (financeiro ou comercial)`);
      return;
    }

    let id = `${item.TABELA}${idx}`

    const cbComercial = item.BLOQUEIOS.COMERCIAL ? `<div class="icheck-primary ml-4">
                                                      <input type="checkbox" class="form-check-input" id="cb${id}-comercial">
                                                      <label class="form-check-label" for="cb${id}-comercial">Comercial</label>
                                                    </div>` : "";

    const cbFinanceiro = item.BLOQUEIOS.FINANCEIRO ? `<div class="icheck-primary ml-4">
                                                        <input type="checkbox" class="form-check-input" id="cb${id}-financeiro">
                                                        <label class="form-check-label" for="cb${id}-financeiro">Financeiro</label>
                                                      </div>` : "";

    // <select class="js-example-programmatic js-states form-control col-md-5" id="txt${id}" name="txt${id}" multiple="multiple"> </select>
    let input = "";
    if (item.INPUT) {

      item.INPUT.map((item, i) => {
        if (input.includes(id)) {
          id = `${id}_${item.TYPE.toUpperCase()}`
        }
        input += item.TYPE.toUpperCase() == 'TEXT'
          ? `<div class="ml-3" style="max-width:350px; min-width:350px;justify-items: right;">
            <label style="margin-bottom: .1rem!important;" data-error="wrong" data-success="right" for="txt${id}">${item.PLACEHOLDER}: </label>
            <div class="input-group">
              <input type="number" class="input-default focus form-control" id="txt${id}" name="txt${id}" class="form-control" placeholder="${item.PLACEHOLDER}">
            </div>
          </div>`
          : item?.COMPONENTEFILTRO.RETORNAMAISDEUMREGISTRO ?
            `<div class="form-group ml-3" style="max-width:350px; min-width:350px;">
              <label data-error="wrong" data-success="right" style="margin-bottom: .1rem!important;" for="txt${id}">${item.PLACEHOLDER}:</label>
              <div class="input-group">
                <select class="input-default focus form-control" id="txt${id}" name="txt${id}" class="form-control" placeholder="${item.PLACEHOLDER}"></select>
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn${id}" name="btn${id}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                <button class="btn bg-danger" id="btnLimpa${id}" name="btnLimpa${id}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>`
            : `<div class="form-group ml-3" style="max-width:350px; min-width:350px;">
              <label data-error="wrong" data-success="right" style="margin-bottom: .1rem!important;" for="txt${id}">${item.PLACEHOLDER}:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txt${id}" name="txt${id}" class="form-control" placeholder="${item.PLACEHOLDER}">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn${id}" name="btn${id}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                <button class="btn bg-danger" id="btnLimpa${id}" name="btnLimpa${id}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>`
      })
    }

    const card = `<div class="d-flex align-center"><div class="col-3 d-flex">${cbComercial}${cbFinanceiro}</div><div class="col-7 d-flex" style="justify-items: right;">${input}</div></div>`;

    return card;
  };

  function criaEventoBotoes(id, compFiltro) {
    componenteFiltro(
      compFiltro.COMP_TABELA,
      compFiltro.RETORNAMAISDEUMREGISTRO,
      false,
      id,
    );
  }

  async function carregaValores() {
    try {
      $.LoadingOverlay("show");
      try {
        const response = await requisicao('GET', '/sisplan/regra_pedido/v1/regra?');

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem, () => { abreCadastroCep(cepInput) }, undefined, undefined);
          return;
        }
        return jsonStr
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  $('#tabLoja').on('click', function () {
    $('#tabVenda').trigger('click')
  })

  $('#tabPedidoCapa').on('click', function () {
    $('#tabPedido').trigger('click')
  })

  $('#tabEstoque').on('click', function () {
    $('#tabMovimentacao').trigger('click')
  })

  function coletarDadosRegra(regra, idx) {
    let id = `${regra.TABELA}${idx}`;
    let dados = {
      regra: regra.DESCRICAO,
      comercial: 'N',
      financeiro: 'N'
    };

    if (regra.BLOQUEIOS.COMERCIAL) {
      dados.comercial = $(`#cb${id}-comercial`).is(':checked') ? 'S' : 'N';
    }
    if (regra.BLOQUEIOS.FINANCEIRO) {
      dados.financeiro = $(`#cb${id}-financeiro`).is(':checked') ? 'S' : 'N';
    }

    regra.INPUT?.map((item) => {
      const inputElement = $(`#txt${id}`);
      let valor = '';
      if (item.COMPONENTEFILTRO) {
        if (regra.INPUT.length == 1 && item.TYPE.toUpperCase() == 'SELECT') {
          valor = formataListasSemAwait($(inputElement).val().toString())

        } else if (regra.INPUT.length > 1 && item.TYPE.toUpperCase() == 'SELECT') {
          id = `${inputElement[0].id}_SELECT`
          valor = formataListasSemAwait($(`#${id}`).val().toString());
        } else {
          const selectedValues = inputElement.val();
          // if (Array.isArray(selectedValues) && selectedValues.length > 0) {//caso passar os valores como pesquisa varios deve tratar isso aq
          // valor = selectedValues.join(',');
          // }
          valor = pegaChave(selectedValues)
        }

        if (valor) {
          if (item.PROPERTY.toUpperCase() == 'DESCRICAO2') {
            dados = { ...dados, DESCRICAO2: valor };
          } else {
            dados = { ...dados, DESCRICAO: valor };
          }
        }

      } else {

        valor = inputElement.val() || '';
        if (valor) {
          dados = { ...dados, DESCRICAO: valor };
        }
      }
    });
    return dados;
  }

  function RetornaInclusao() {
    const regras = new Array(35).fill(null);

    regrasPedido.filter(item => item.TIPO === "INCLUSAO").forEach((regra, index) => {
      const idx = regrasPedido.indexOf(regra) + 1;
      const dadosRegra = coletarDadosRegra(regra, idx);

      regras[parseInt(regra.REGRA) - 1] = dadosRegra;
    });

    return { regras: regras.filter(r => r !== null) };
  }

  function RetornaAlteracao() {
    const regras = new Array(40).fill(null);

    regrasPedido.filter(item => item.TIPO === "ALTERACAO").forEach((regra, index) => {
      const idx = regrasPedido.indexOf(regra) + 1;
      const dadosRegra = coletarDadosRegra(regra, idx);

      regras[parseInt(regra.REGRA) - 1] = dadosRegra;
    });

    return { regras: regras.filter(r => r !== null) };
  }

  async function preencheCampos() {
    $.LoadingOverlay('show')
    try {
      const regras = await carregaValores();

      for (let x = 0; x < regrasPedido.length; x++) {
        const campos = regrasPedido[x];
        $(`#tabelaRegraPedido${campos.TIPO}`).DataTable().row.add([
          `Regra ${campos.CODIGO}`,
          campos.DESCRICAO,
          retornaLinhaTabela(campos, x + 1)
        ]).draw(false);
      }

      for (let x = 0; x < regrasPedido.length; x++) {
        const campos = regrasPedido[x];
        if (existePesquisa(campos)) {
          campos.INPUT.forEach((item) => {
            if (item.COMPONENTEFILTRO) {
              let id = `${campos.TABELA}${x + 1}`
              if (campos.INPUT.length > 1 && item.TYPE.toUpperCase() == 'SELECT') {
                id = `${campos.TABELA}${x + 1}_SELECT`
              }
              criaEventoBotoes(id, item.COMPONENTEFILTRO);
            }
          })
        }
      }

      if (regras) {
        await preencherValoresRegras(regras);
      }

    } catch (error) {
      msgAlerta(error.message || 'Não conseguiu encontrar as regras')
    } finally {
      $.LoadingOverlay('hide')
    }
    await adicionaEmpresas();
  }

  const buscaValorRegrasSelect = async (tabela, camposPesquisa) => {
    let response = ''

    if (tabela === 'GRUPO_PA') {
      response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "GRUPO_PA", "camposSelect": ["CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${camposPesquisa})"]}`)
    } if (tabela === 'MOEDA') {
      response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "MOEDA", "camposSelect": ["CODMOE CODIGO", "DESCRICAO"], "where": ["CODMOE IN (${camposPesquisa})"]}`)
    } if (tabela === 'TABSIT') {
      response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "TABSIT", "camposSelect": ["CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${camposPesquisa})"]}`)
    } if (tabela === 'HISTCP') {
      response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "HISTCP", "camposSelect": ["HISTORICO CODIGO", "DESCRICAO"], "where": ["HISTORICO IN (${camposPesquisa})"]}`)
    } if (tabela === 'TIPO') {
      response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "TIPO", "camposSelect": ["ID CODIGO", "DESCRICAO"], "where": ["ID IN (${camposPesquisa})"]}`)
    } 
    if (tabela === 'AUXILIAR') {
      response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "AUXILIAR", "camposSelect": ["ID CODIGO", "DESCRICAO"], "where": ["ID IN (${camposPesquisa})"]}`)
    } 
    if (tabela === 'TABUF') {
      response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela": "TABUF", "camposSelect": ["CODIGO", "DESCRICAO"], "where": ["CODIGO IN (${camposPesquisa})"]}`)
    } 

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr.RESULT[0].mensagem);
      return;
    }
    return jsonStr.RESULT[0]
  }

  async function preencherValoresRegras(regras) {
    for (let x = 0; x < regrasPedido.length; x++) {

      const campo = regrasPedido[x];
      const idx = x + 1;
      const id = `${campo.TABELA}${idx}`;
      const tipoRegra = campo.TIPO.toLowerCase();
      const nomeRegra = `regra${campo.REGRA}`;

      if (regras[tipoRegra] && regras[tipoRegra][nomeRegra]) {
        const valorRegra = regras[tipoRegra][nomeRegra];

        if (campo.BLOQUEIOS.COMERCIAL && valorRegra.hasOwnProperty('comercial')) {
          $(`#cb${id}-comercial`).prop('checked', valorRegra.comercial === 'S');
        }
        if (campo.BLOQUEIOS.FINANCEIRO && valorRegra.hasOwnProperty('financeiro')) {
          $(`#cb${id}-financeiro`).prop('checked', valorRegra.financeiro === 'S');
        }

        if (!campo.INPUT) continue

        campo.INPUT.map(async (item) => {
          if (campo.INPUT.length == 1 && item.TYPE.toUpperCase() == 'SELECT') {
            if (valorRegra.hasOwnProperty('descricao') && valorRegra.descricao) {
              buscaValorRegrasSelect(item.COMPONENTEFILTRO?.TABELA, valorRegra.descricao).then(async (resultado) => {
                await insereValorPesquisaVarios(`txt${id}`, 'CODIGO', 'DESCRICAO', resultado);
              })
            } else if (valorRegra.hasOwnProperty('descricao2') && valorRegra.descricao2 && item.COMPONENTEFILTRO.RETORNAMAISDEUMREGISTRO) {
              buscaValorRegrasSelect(item.COMPONENTEFILTRO?.TABELA, valorRegra.descricao2).then(async (resultado) => {
                await insereValorPesquisaVarios(`txt${id}`, 'CODIGO', 'DESCRICAO', resultado);
              })
            } else if (valorRegra.hasOwnProperty('descricao2') && valorRegra.descricao2 && !item.COMPONENTEFILTRO.RETORNAMAISDEUMREGISTRO) {
              $(`#txt${id}`).val(valorRegra.descricao2.replace(/'/g, ""));
              // await insereValor(`txt${id}`, pegaChave(valorRegra.descricao2.replace(/'/g, "")), pegaDescricao(valorRegra.descricao2).replace(/'/g, ""));
            }

          } else if (campo.INPUT.length > 1 && item.TYPE.toUpperCase() == 'SELECT') {
            if (valorRegra.hasOwnProperty('descricao2') && valorRegra.descricao2) {
              buscaValorRegrasSelect(item.COMPONENTEFILTRO?.TABELA, valorRegra.descricao2).then(async (resultado) => {
                await insereValorPesquisaVarios(`txt${id}_SELECT`, 'CODIGO', 'DESCRICAO', resultado);
              })
            }
          } else {
            $(`#txt${id}`).val(valorRegra.descricao)
          }
        })

      }
    }
  }

  async function Gravar() {
    try {
      $.LoadingOverlay("show");

      const body = {
        Inclusao: await RetornaInclusao(),
        Alteracao: await RetornaAlteracao()
      };

      const response = await requisicao('POST', '/sisplan/regra_pedido/v1/regra?', '', JSON.stringify(body));

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status !== 200) {
        msgAlerta(jsonStr.mensagem);
        return;
      }

      msgSucesso('Regras salvas com sucesso!');

    } catch (error) {
      console.error(error);
      msgAlerta('Erro ao salvar regras: ' + error.message);
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#tabPedidoCapa').trigger('click')
  $('#tabInclusaoPedido').trigger('click')  


  //#region Regra Manual

  $('#txtBloqRetRegraManual').autocompleta(1, `JSON={ "tabela":"PED_REGRAS", "camposSelect":[ "CODIGO CHAVE", "REGRA DESCRICAO"], "where": ["TIPO = 'M'"]}`);  
  $('#btnBloqRetRegraManual').pesquisa('#txtBloqRetRegraManual', 'CODIGO', 'REGRA', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PED_REGRAS", "camposSelect":[ "CODIGO", "REGRA" ], "where": ["TIPO = 'M'"]}`, 'Pesquisa Regra de Pedido', 'PED_REGRA');  
  $("#btnLimpaBloqRetRegraManual").on("click", function () {
    $("#txtBloqRetRegraManual").val("");
  })

  $("#tabRegraManual").on("click", function () {
    $("#btnGravar").addClass("d-none");
  })

  $("#btnIncluirRegraManual").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      const RegraManual = montaObjetoRegraManual();
      validarRegraManual(RegraManual);
      await gravarRegraManual(RegraManual);  
      await preencherRegrasManuais();
      limparCamposRegrasManuais();
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay("hide");
    }
  })

  $('a[href="#divRegraManual"]').on('shown.bs.tab', async function () {
    criarDataTableRegrasManuais();
    await preencherRegrasManuais();
  });

  $("#tabelaRegrasManuais tbody").on("click", ".btnExcluirRegraManual", async function () {    
    $.LoadingOverlay("show");
    try {
      if (verificarAlteracaoRegraManual()) {
        throw new Error("Não é possível realizar a exclusão, você está no modo de alteração.");
      }

      const codigo = $('#tabelaRegrasManuais').DataTable().row($(this).closest('tr')).data().CODIGO;    
      await excluirRegraManual(codigo);
      await preencherRegrasManuais();
      criaMensagemSucesso('Regra manual foi excluída com sucesso.');
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay("hide");
    }    
  })

  $("#tabelaRegrasManuais tbody").on("click", ".btnAlterarRegraManual", async function () {
    $.LoadingOverlay("show");
    try {
      if (verificarAlteracaoRegraManual()) {
        throw new Error("Não é possível realizar a alteração, você já está no modo de alteração.");
      }

      alternarIncluirEditarRegraManual(true);
      const registro = $("#tabelaRegrasManuais").DataTable().row($(this).closest('tr')).data();
      $(this).closest("tr").addClass("selected");
      preencherCamposRegraManual(registro);
    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay("hide");
    }  
  })

  $("#btnCancelarRegraManual").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      let bAbort = false;
      await msgAguardaConfirmacao("Você tem certeza que deseja cancelar as alterações?", () => {}, () => { bAbort = true; });

      if (!bAbort) {
        alternarIncluirEditarRegraManual(false);
        limparCamposRegrasManuais();
        $('#tabelaRegrasManuais').DataTable().$('tr.selected').removeClass('selected');
      }
    } finally {
      $.LoadingOverlay("hide");
    }    
  })

  $("#btnConfirmarRegraManual").on("click", async function () {
    $.LoadingOverlay("show");
    try {
      const RegraManual = montaObjetoRegraManual();
      validarRegraManual(RegraManual);
      await gravarRegraManual(RegraManual);  
      await preencherRegrasManuais();
      limparCamposRegrasManuais();
      alternarIncluirEditarRegraManual(false);
    } catch(error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay("hide");
    }
  }) 

  function validarRegraManual(RegraManual) {

    if (RegraManual.REGRA == "") {
      throw new Error("Necessário informar uma descrição para a regra manual.");
    }      

    if (RegraManual.COMERCIAL == "N" && RegraManual.FINANCEIRO == "N") {
      throw new Error("Necessário informar um tipo de bloqueio.");
    }
    
  }

  async function gravarRegraManual(RegraManual) {
    const response = await requisicao('POST', '/sisplan/regra_pedido/v1/regramanual?', "", JSON.stringify(RegraManual), 120000);

    if (!response) {
      throw new Error("Não foi possível gravar a regra manual.");
    }

    if (response.status != 200) {
      const json = await response.json();
      throw new Error(json.mensagem);
    }
  }

  function montaObjetoRegraManual() {

    const RegraManual = {     
      CODIGO: $("#txtCodigoRegraManual").val(),
      REGRA: $("#txtDescricaoRegraManual").val(),
      COMERCIAL: $("#cbComercial").prop("checked") ? "S" : "N",
      FINANCEIRO: $("#cbFinanceiro").prop("checked") ? "S" : "N",
      TIPO: "M",
      BLOQ_RET: pegaChave("#txtBloqRetRegraManual")      
    }

    return RegraManual;

  }

  async function consultarRegrasManuais() {
    const response = await requisicao('GET', '/sisplan/regra_pedido/v1/regramanual?', "", "", 120000);

    if (!response) {
      throw new Error("Não foi possível consultar as regras manuais.");
    }

    const json = await response.json();
    if (response.status != 200) {
      throw new Error(json.mensagem);
    }

    return json;
  }

  async function preencherRegrasManuais() {
    limparDataTableRegrasManuais();
    const dados = await consultarRegrasManuais();
    $("#tabelaRegrasManuais").DataTable().rows.add(dados).draw(false);
  }

  function criarDataTableRegrasManuais() {
    const colunas = [
      { data: 'CODIGO', title: 'Código' },
      { data: 'REGRA', title: 'Regra' },
      { data: 'ID', title: 'ID' },
      { data: 'BLOQ_RET', title: 'Bloq. Ret.' },
      { data: 'DESC_BLOQ_RET', title: 'Desc. Bloq. Ret.' },
      { data: 'BLOQ_COMER', title: 'Bloq. Comercial' },
      { data: 'BLOQ_FINAN', title: 'Bloq. Financeiro' }
    ];

    const botoes = [
      ["Alterar", "btnAlterarRegraManual"],                
      ["Excluir", "btnExcluirRegraManual"]
    ];

    if (!$.fn.DataTable.isDataTable('#tabelaRegrasManuais')) {
      criaDataTablePadrao("#tabelaRegrasManuais"
                         ,true
                         ,false
                         ,true
                         ,true
                         ,true
                         ,false
                         ,"400px"
                         ,null
                         ,colunas
                         ,[2,3,4,5,6]
                         ,[]
                         ,[]
                         ,[]
                         ,{}
                         ,2
                         ,''
                         ,''
                         ,false
                         ,[]
                         ,[]
                         ,false
                         ,false
                         ,false
                         ,true
                         ,botoes);
    };
  }  

  function limparDataTableRegrasManuais() {
    if ($.fn.DataTable.isDataTable('#tabelaRegrasManuais')) {
      $("#tabelaRegrasManuais").DataTable().clear().draw(false);
    };
  }

  function limparCamposRegrasManuais() {
    $("#txtCodigoRegraManual").val("");
    $("#txtDescricaoRegraManual").val("");
    $("#txtBloqRetRegraManual").val("");
    $("#cbComercial").prop("checked", false);
    $("#cbFinanceiro").prop("checked", false);
  }  

  async function excluirRegraManual(codigo) {
    const params = `CODIGO=${codigo}`;
    const response = await requisicao('DELETE', '/sisplan/regra_pedido/v1/regramanual?', params, "", 120000);

    if (!response) {
      throw new Error("Não foi possível excluir a regra manual.");
    }

    if (response.status != 200) {
      const json = await response.json();
      throw new Error(json.mensagem);
    }  
  }  

  function alternarIncluirEditarRegraManual(bEditar) {
    if (bEditar) {
      $("#divAlterarRegraManual").removeClass("d-none");
      $("#divIncluirRegraManual").addClass("d-none");
    } else {
      $("#divAlterarRegraManual").addClass("d-none");
      $("#divIncluirRegraManual").removeClass("d-none");
    }
  }
  
  function preencherCamposRegraManual(RegraManual) {
    $("#txtCodigoRegraManual").val(RegraManual.CODIGO);
    $("#txtDescricaoRegraManual").val(RegraManual.REGRA);  
    insereValor('#txtBloqRetRegraManual', RegraManual.BLOQ_RET, RegraManual.DESC_BLOQ_RET);
    $("#cbComercial").prop("checked", RegraManual.BLOQ_COMER == "S");
    $("#cbFinanceiro").prop("checked", RegraManual.BLOQ_FINAN == "S");
  }

  function verificarAlteracaoRegraManual() {
    return !$("#divAlterarRegraManual").hasClass("d-none");
  }
  //#endregion

});
